// shellSort.java
// Program demonstruje sortowanie metod Shella
// Aby uruchomi program: C>java ShellSortApp
//--------------------------------------------------------------
class ArraySh
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo sortowanych elementw
//--------------------------------------------------------------
   public ArraySh(int max)           // konstruktor
      {
      theArray = new long[max];      // tworzymy tablic
      nElems = 0;                    // pocztkowo pust
      }
//--------------------------------------------------------------
   public void insert(long value)    // zapisanie elementu w tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy wielko tablicy
      }
//--------------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      System.out.print("A=");
      for(int j=0; j<nElems; j++)    // dla kadego elementu
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
//--------------------------------------------------------------
   public void shellSort()
      {
      int inner, outer;
      long temp;

      int h = 1;                     // wyznaczamy pocztkow warto h
      while(h <= nElems/3)
         h = h*3 + 1;                // (1, 4, 13, 40, 121, ...)

      while(h>0)                     // zmniejszamy h, a do momentu gdy h=1
         {
                                     // sortujemy tablic z wykorzystaniem odstpu
                                     // o okrelonej wielkoci
         for(outer=h; outer<nElems; outer++)
            {
            temp = theArray[outer];
            inner = outer;
                                     // jeden podprzebieg sortowania (eg 0, 4, 8)
            while(inner > h-1 && theArray[inner-h] >=  temp)
               {
               theArray[inner] = theArray[inner-h];
               inner -= h;
               }
            theArray[inner] = temp;
            }  // koniec ptli for
         h = (h-1) / 3;              // zmniejszamy warto h
         }  // koniec ptli while(h>0)
      }  // koniec metody shellSort()
//--------------------------------------------------------------
   }  // koniec klasy ArraySh
////////////////////////////////////////////////////////////////
class ShellSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 10;             // wielko tablicy
      ArraySh arr;
      arr = new ArraySh(maxSize);   // tworzymy tablic

      for(int j=0; j<maxSize; j++)  // wypeniamy tablic 
         {                          // liczbami losowymi
         long n = (int)(java.lang.Math.random()*99);
         arr.insert(n);
         }
      arr.display();                // wywietlamy nieuporzdkowan tablic
      arr.shellSort();              // sortujemy tablic metod Shella
      arr.display();                // wywietlamy posortowan tablic
      }  // konie meotdy main()
   }  // koniec klasy ShellSortApp
////////////////////////////////////////////////////////////////
